<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCityInBlueAndGoldByParams(array $params)
 * @method getStoresByCityIdsByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得当前有门店的所有城市(金标，蓝标)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCityInBlueAndGold () {
        return self::getClass()->getCityInBlueAndGold();
    }

    /**
     * 通过城市ids获得门店(金标，蓝标)
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoresByCityIds () {
        return self::getClass()->getStoresByCityIds();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}