<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method forgetUserPasswordByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过验证码更改登录密码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPassword([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}