<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array $params)
 * @method getMultiStoreReservationsByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表数据
     *
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @support  array $productGroup 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReservationList () {
        return self::getClass()->getReservationList();
    }

    /**
     * 获取多门店可预约时间段信息
     *
     * @support  string $date 当前日期 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @support  array $productGroup 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMultiStoreReservations () {
        return self::getClass()->getMultiStoreReservations();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Product\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Product\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}