<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductDiscountDetailByStoreIdByParams(array $params)
 * @method getAllCategoriesByStoreIdByParams(array $params)
 * @method getCategoryProductByStoreIdAndCatIdByParams(array $params)
 * @method getBatchDetailByProductIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过门店id获得商品折扣信息
     *
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountDetailByStoreId () {
        return self::getClass()->getProductDiscountDetailByStoreId();
    }

    /**
     * 通过门店id获得所有类目信息
     *
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllCategoriesByStoreId () {
        return self::getClass()->getAllCategoriesByStoreId();
    }

    /**
     * 通过门店和类目id获得商品信息
     *
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @support  int $categoryId 类目id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryProductByStoreIdAndCatId () {
        return self::getClass()->getCategoryProductByStoreIdAndCatId();
    }

    /**
     * 批量获取多个产品详情
     *
     * @support  array $productIds 产品ID [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBatchDetailByProductIds () {
        return self::getClass()->getBatchDetailByProductIds();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}