<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvisibleCaptchaUseTencentByParams(array $params)
 * @method getSmsCodeWithInvisibleTencentByParams(array $params)
 */
class Notify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [腾讯]无痕验证
     *
     * @support  string $captchaId 无痕验证应用ID 
     * @support  string $phone 手机号码 [ require true ]
     * @support  string $ticket 前端回调ticket [ require true ]
     * @support  string $randStr 前端回调randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvisibleCaptchaUseTencent () {
        return self::getClass()->getInvisibleCaptchaUseTencent();
    }

    /**
     * 通过无痕验证后发送短信验证码
     *
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $token Token验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithInvisibleTencent (string $phone, string $token) {
        return self::getClass()->getSmsCodeWithInvisibleTencent([
            "phone" => $phone,
            "token" => $token,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\Notify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\Notify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}