<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  array $detail 订单详情(商品&amp;服务详情) [ require true ]
     * @support  float $giftCardMoney 礼品卡抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $productDiscountIds 组合优惠id 
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $storeId 门店id [ require true ]
     * @support  int $channel 渠道号 
     * @support  string $note 备注 
     * @support  float $oriMoney 原始价格 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取订单详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDetail () {
        return self::getClass()->getOrderDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}