<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addNewPaymentByParams(array $params)
 * @method zeroByParams(array $params)
 * @method getStorePayTypeByParams(array $params)
 * @method callBackByParams(array $params)
 * @method messageOrderAfterPayByParams(array $params)
 * @method bindStorePayTypeByParams(array $params)
 * @method deleteBindStorePayTypeByParams(array $params)
 * @method closeByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建支付单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  float $money 需要支付的金额(单位为元) [ require true ]
     * @support  string $sendUrlStaffId 发送支付链接id require false
     * @support  string $payUrlCreateTime 支付链接创建时间 require false
     * @support  string $openId openId require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewPayment () {
        return self::getClass()->addNewPayment();
    }

    /**
     * 零元支付
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function zero () {
        return self::getClass()->zero();
    }

    /**
     * 获取门店允许的支付类型
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorePayType () {
        return self::getClass()->getStorePayType();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callBack () {
        return self::getClass()->callBack();
    }

    /**
     * 订单支付成功消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageOrderAfterPay () {
        return self::getClass()->messageOrderAfterPay();
    }

    /**
     * 绑定门店支付类型
     *
     * @support  int $storeId 门店ID require false
     * @support  string $payType 支付类型 require false
     * @support  string $merchantId 商户ID require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindStorePayType () {
        return self::getClass()->bindStorePayType();
    }

    /**
     * 解绑门店支付类型
     *
     * @support  int $storeId 门店ID require false
     * @support  string $payType 支付类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteBindStorePayType () {
        return self::getClass()->deleteBindStorePayType();
    }

    /**
     * 关闭支付单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}