<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPermissionByParams(array $params)
 */
class Manage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 给当前伙伴设置权限
     *
     * @support  int $staffId staff_id require false
     * @support  string $token token [ require true ]
     * @support  array $permissionIds 权限ids require false
     * @support  array $delPermissionIds 要删除的权限ids require false
     * @support  int $permissionId 新增权限id require false
     * @support  int $delPermissionId 删除权限id require false
     * @support  array $storeIds 新增门店ids require false
     * @support  array $delStoreIds 删除门店ids require false
     * @support  bool $isAddAppId 应用Id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPermission () {
        return self::getClass()->createPermission();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Manage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Manage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}