<?php
namespace Mainto\Bridge\Invokes\ProjectKids\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronOrderAutoServiceCompleteByParams(array $params)
 * @method cronOrderSaleSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderAppendUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderWaitLookPhotoAutoServiceCompleteByParams(array $params)
 */
class OrderCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片完成15天后订单服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoServiceComplete () {
        return self::getClass()->cronOrderAutoServiceComplete();
    }

    /**
     * 看片完成15天后拍摄产品服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderSaleSkuAutoServiceComplete () {
        return self::getClass()->cronOrderSaleSkuAutoServiceComplete();
    }

    /**
     * 看片完成15天后升级体验服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderUpgradeSkuAutoServiceComplete () {
        return self::getClass()->cronOrderUpgradeSkuAutoServiceComplete();
    }

    /**
     * 创建订单37天后追加的升级体验服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAppendUpgradeSkuAutoServiceComplete () {
        return self::getClass()->cronOrderAppendUpgradeSkuAutoServiceComplete();
    }

    /**
     * 待看片37天后自动看片和服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderWaitLookPhotoAutoServiceComplete () {
        return self::getClass()->cronOrderWaitLookPhotoAutoServiceComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Cron\OrderCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Cron\OrderCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}