<?php
namespace Mainto\Bridge\Invokes\ProjectKids\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronOrderAutoServiceCompleteByParams(array $params)
 * @method cronOrderSaleSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderAppendUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderWaitLookPhotoAutoServiceCompleteByParams(array $params)
 */
class OrderCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 15天订单服务完成
     *
     * @param  string $date 执行日期 [ require true ]
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoServiceComplete (string $date = '', bool $isTesting = false) {
        return self::getClass()->cronOrderAutoServiceComplete([
            "date" => $date,
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 15天拍摄产品服务完成
     *
     * @param  string $date 执行日期 [ require true ]
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderSaleSkuAutoServiceComplete (string $date = '', bool $isTesting = false) {
        return self::getClass()->cronOrderSaleSkuAutoServiceComplete([
            "date" => $date,
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 15天升级体验服务完成
     *
     * @param  string $date 执行日期 [ require true ]
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderUpgradeSkuAutoServiceComplete (string $date = '', bool $isTesting = false) {
        return self::getClass()->cronOrderUpgradeSkuAutoServiceComplete([
            "date" => $date,
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 37天追加的升级体验服务完成
     *
     * @param  string $date 执行日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAppendUpgradeSkuAutoServiceComplete (string $date = '') {
        return self::getClass()->cronOrderAppendUpgradeSkuAutoServiceComplete([
            "date" => $date,
        ]);
    }

    /**
     * 37天待看片自动完成
     *
     * @param  string $date 执行日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderWaitLookPhotoAutoServiceComplete (string $date = '') {
        return self::getClass()->cronOrderWaitLookPhotoAutoServiceComplete([
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Cron\OrderCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Cron\OrderCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}