<?php
namespace Mainto\Bridge\Invokes\ProjectKids\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method registerGeeTestByParams(array $params)
 * @method validateGeeTestByParams(array $params)
 * @method getSmsCodeByGeeTokenByParams(array $params)
 */
class GeeTest {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 极验初始化
     *
     * @support  string $clientType 客户端类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function registerGeeTest () {
        return self::getClass()->registerGeeTest();
    }

    /**
     * 极验验证
     *
     * @support  string $geeTestChallenge 流水号，一次完整验证流程的唯一标识 
     * @support  string $geeTestValidate validate 
     * @support  string $geeTestSecCode 核心校验数据 
     * @support  string $phone 核心校验数据 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function validateGeeTest () {
        return self::getClass()->validateGeeTest();
    }

    /**
     * 根据极验令牌发送短信验证码
     *
     * @support  string $type 发送类型 [ require true ]
     * @support  string $phone 发送手机号码 [ require true ]
     * @support  string $token Token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeByGeeToken () {
        return self::getClass()->getSmsCodeByGeeToken();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'User\GeeTest');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'User\GeeTest');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}