<?php
namespace Mainto\Bridge\Invokes\ProjectKids\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookOrderLookPhotoMessageByParams(array $params)
 * @method hookOrderLookPhotoCompleteOnlineMessageByParams(array $params)
 */
class OrderMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单看片方式通知
     *
     * @support  int $orderId 订单id [Original type uint] [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookOrderLookPhotoMessage () {
        return self::getClass()->hookOrderLookPhotoMessage();
    }

    /**
     * 看片完成通知
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookOrderLookPhotoCompleteOnlineMessage () {
        return self::getClass()->hookOrderLookPhotoCompleteOnlineMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'MessageHook\OrderMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'MessageHook\OrderMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}