<?php
namespace Mainto\Bridge\Invokes\ProjectKids\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronAutoOrderServiceCompleteByParams(array $params)
 * @method cronAutoOrderSaleSkuServiceCompleteByParams(array $params)
 * @method cronAutoOrderUpgradeSkuServiceCompleteByParams(array $params)
 * @method cronOrderAutoWaitLookPhotoCompleteByParams(array $params)
 */
class OrderCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 15天订单服务完成
     *
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronAutoOrderServiceComplete (bool $isTesting = false) {
        return self::getClass()->cronAutoOrderServiceComplete([
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 15天拍摄产品服务完成
     *
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronAutoOrderSaleSkuServiceComplete (bool $isTesting = false) {
        return self::getClass()->cronAutoOrderSaleSkuServiceComplete([
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 15天升级体验服务完成
     *
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronAutoOrderUpgradeSkuServiceComplete (bool $isTesting = false) {
        return self::getClass()->cronAutoOrderUpgradeSkuServiceComplete([
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 37天待看片自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoWaitLookPhotoComplete () {
        return self::getClass()->cronOrderAutoWaitLookPhotoComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Cron\OrderCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Cron\OrderCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}