<?php
namespace Mainto\Bridge\Invokes\ProjectKids\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method testCreateByParams(array $params)
 * @method testCreateDesignByParams(array $params)
 * @method testCreateShopByParams(array $params)
 * @method testCreateShopCooInfoByParams(array $params)
 * @method testCreateShopDepositByParams(array $params)
 * @method testCreateShopRentsByParams(array $params)
 * @method testCreateMarketPeopleByParams(array $params)
 * @method testCreateStaffByParams(array $params)
 * @method testCreatePeopleReserveByParams(array $params)
 * @method testCreateOpenStoreTasksByParams(array $params)
 */
class StoreCreate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * test创建门店
     *
     * @support  string $store_id 门店名称 
     * @support  string $name 门店名称 
     * @support  string $store_type 门店类型 
     * @support  string $store_type_name 门店类型名称 
     * @support  string $store_level 门店等级 
     * @support  string $store_level_name 门店等级名称 
     * @support  string $market_mature_info 商场成熟度 
     * @support  string $city_id 所属城市编码 
     * @support  string $city_name 所属城市 
     * @support  string $city_level 城市级别编码 
     * @support  string $market_id 所属商场编码 
     * @support  string $market_name 所属商场名称 
     * @support  string $business_district 所属商圈 
     * @support  string $market_address 商场地址 
     * @support  string $area 所属区域 
     * @support  string $regional_manager 区域经理 
     * @support  string $city_manager 城市经理 
     * @support  string $development_experts 拓展专家 
     * @support  string $plan_start_time 预计开业时间 
     * @support  string $status 项目状态 
     * @support  string $delay_reason 延迟开业原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreate () {
        return self::getClass()->testCreate();
    }

    /**
     * test创建门店设计图
     *
     * @support  string $store_id 门店id 
     * @support  string $file_requirement 附件要求 
     * @support  string $file_name 附件名称版本 
     * @support  string $upload_time 上传日期 
     * @support  string $update_by 更新人 
     * @support  array $paths 文件地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateDesign () {
        return self::getClass()->testCreateDesign();
    }

    /**
     * test创建门店店铺信息
     *
     * @support  string $store_id 门店名称 
     * @support  string $landing_floor 门店名称 
     * @support  string $shop_no 门店类型 
     * @support  string $pay_type 门店类型名称 
     * @support  string $month_sales_estimate 门店等级 
     * @support  string $studio_config 门店等级名称 
     * @support  string $makeup_config 商场成熟度 
     * @support  string $later_stage_config 所属城市编码 
     * @support  bool $can_pets 所属城市 
     * @support  string $market_requirement 城市级别编码 
     * @support  string $company 所属商场编码 
     * @support  string $create_by 所属商场名称 
     * @support  string $update_by 所属商圈 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShop () {
        return self::getClass()->testCreateShop();
    }

    /**
     * test创建门店商务合作信息
     *
     * @support  string $store_id 门店id 
     * @support  string $lease_start_at 租赁开始日期 
     * @support  string $lease_end_at 租赁结束日期 
     * @support  string $renovation_free_time 装修免租期 
     * @support  string $renovation_type 租赁方式 
     * @support  string $renovation_condition 租赁条件 
     * @support  string $management_free_time 经营免租期 
     * @support  string $points 扣点 
     * @support  string $exclusive 排他 
     * @support  string $advertising_space 广告位 
     * @support  string $payment_cycle 缴费周期 
     * @support  string $deposit 押金金额 
     * @support  string $property_fee 物业管理费 
     * @support  string $promotion_fee 推广费 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShopCooInfo () {
        return self::getClass()->testCreateShopCooInfo();
    }

    /**
     * test创建门店定金
     *
     * @support  string $store_id 门店id 
     * @support  string $name 押金名称 
     * @support  string $money 押金金额 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShopDeposit () {
        return self::getClass()->testCreateShopDeposit();
    }

    /**
     * test创建门店租金
     *
     * @support  string $store_id 门店id 
     * @support  string $should_pay_time 缴费周期 
     * @support  string $detail 租金明细 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShopRents () {
        return self::getClass()->testCreateShopRents();
    }

    /**
     * test创建商场联系人
     *
     * @support  string $store_id 门店id 
     * @support  string $post 岗位 
     * @support  string $people 联系人 
     * @support  string $phone 联系方式 
     * @support  string $email 邮箱 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateMarketPeople () {
        return self::getClass()->testCreateMarketPeople();
    }

    /**
     * test创建门店员工
     *
     * @support  string $store_id 门店id 
     * @support  string $post 岗位 
     * @support  string $staff_name 联系人 
     * @support  string $phone 联系方式 
     * @support  string $email 邮箱 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateStaff () {
        return self::getClass()->testCreateStaff();
    }

    /**
     * test创建门店人员储备
     *
     * @support  string $store_id 门店id 
     * @support  string $post 岗位 
     * @support  string $people_num 人数 
     * @support  string $people_detail 具体人员 
     * @support  string $phone 联系方式 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreatePeopleReserve () {
        return self::getClass()->testCreatePeopleReserve();
    }

    /**
     * test创建新店开业任务
     *
     * @support  string $store_id 门店id 
     * @support  string $type 类型 
     * @support  string $todo_list 事项清单 
     * @support  string $something 需要做什么 
     * @support  string $plan_finished_at 计划完成时间 
     * @support  string $finished_at 实际完成时间 
     * @support  array $related_documents 相关文件 
     * @support  bool $finish_status 完成状态 
     * @support  string $can_call_handover_person 可联系对接人 
     * @support  string $create_by 创建人 
     * @support  string $update_by 更新人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateOpenStoreTasks () {
        return self::getClass()->testCreateOpenStoreTasks();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'StoreInformatization\StoreCreate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'StoreInformatization\StoreCreate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}