<?php
namespace Mainto\Bridge\Invokes\ProjectKids\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkNpsByParams(array $params)
 * @method createNPSByParams(array $params)
 * @method getSnStatusByParams(array $params)
 * @method getSnQuestionByParams(array $params)
 * @method createSnByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测nps是否提交
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkNps () {
        return self::getClass()->checkNps();
    }

    /**
     * 提交NPS问卷
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  int $npsAll 总分 [ require true ]
     * @support  int $npsReceptionist 门市客服评分 [ require true ]
     * @support  int $npsCameraman 摄影师平分 [ require true ]
     * @support  int $npsDresser 化妆师评分 [ require true ]
     * @support  int $npsRetoucher 看片师评分 [ require true ]
     * @support  string $npsNote 其他反馈 
     * @support  int $isSn 是否参与SN 
     * @support  string $shareReason 参与分享秀原因 
     * @support  int $isShare 是否参与分享 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNPS () {
        return self::getClass()->createNPS();
    }

    /**
     * 获取SN状态（判断用户是否提交过sn）
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSnStatus () {
        return self::getClass()->getSnStatus();
    }

    /**
     * 获取SN问卷
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSnQuestion () {
        return self::getClass()->getSnQuestion();
    }

    /**
     * 提交SN问卷
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  array $answers 答案组 [ require true ]
     * @support  string $note sn意见 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSn () {
        return self::getClass()->createSn();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'User\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'User\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}