<?php
namespace Mainto\Bridge\Invokes\ProjectKids\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method testCreateByParams(array $params)
 * @method testCreateDesignByParams(array $params)
 * @method testCreateShopByParams(array $params)
 */
class StoreCreate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * test创建门店
     *
     * @support  string $store_id 门店名称 
     * @support  string $name 门店名称 
     * @support  string $store_type 门店类型 
     * @support  string $store_type_name 门店类型名称 
     * @support  string $store_level 门店等级 
     * @support  string $store_level_name 门店等级名称 
     * @support  string $market_mature_info 商场成熟度 
     * @support  string $city_id 所属城市编码 
     * @support  string $city_name 所属城市 
     * @support  string $city_level 城市级别编码 
     * @support  string $market_id 所属商场编码 
     * @support  string $market_name 所属商场名称 
     * @support  string $business_district 所属商圈 
     * @support  string $market_address 商场地址 
     * @support  string $area 所属区域 
     * @support  string $regional_manager 区域经理 
     * @support  string $city_manager 城市经理 
     * @support  string $development_experts 拓展专家 
     * @support  string $plan_start_time 预计开业时间 
     * @support  string $status 项目状态 
     * @support  string $delay_reason 延迟开业原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreate () {
        return self::getClass()->testCreate();
    }

    /**
     * test创建门店设计图
     *
     * @support  string $store_id 门店id 
     * @support  string $file_requirement 附件要求 
     * @support  string $file_name 附件名称版本 
     * @support  string $upload_time 上传日期 
     * @support  string $update_by 更新人 
     * @support  array $paths 文件地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateDesign () {
        return self::getClass()->testCreateDesign();
    }

    /**
     * test创建门店店铺信息
     *
     * @support  string $store_id 门店名称 
     * @support  string $landing_floor 门店名称 
     * @support  string $shop_no 门店类型 
     * @support  string $pay_type 门店类型名称 
     * @support  string $month_sales_estimate 门店等级 
     * @support  string $studio_config 门店等级名称 
     * @support  string $makeup_config 商场成熟度 
     * @support  string $later_stage_config 所属城市编码 
     * @support  bool $can_pets 所属城市 
     * @support  string $market_requirement 城市级别编码 
     * @support  string $Company 所属商场编码 
     * @support  string $create_by 所属商场名称 
     * @support  string $update_by 所属商圈 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShop () {
        return self::getClass()->testCreateShop();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'StoreInformatization\StoreCreate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'StoreInformatization\StoreCreate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}