<?php
namespace Mainto\Bridge\Invokes\ProjectKids\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeListByParams(array $params)
 * @method detailByParams(array $params)
 * @method getDesignChartsByParams(array $params)
 * @method getStoreShopInfoByParams(array $params)
 * @method getBusinessCooperationInformationByParams(array $params)
 * @method getpeopleInfoByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店列表
     *
     * @support  string $storeType 门店类型 
     * @support  string $storeName 门店名称 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeList () {
        return self::getClass()->storeList();
    }

    /**
     * 获取单条门店
     *
     * @support  string $storeId 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取门店设计图
     *
     * @support  string $storeId 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDesignCharts () {
        return self::getClass()->getDesignCharts();
    }

    /**
     * 获取门店商铺信息
     *
     * @support  string $storeId 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreShopInfo () {
        return self::getClass()->getStoreShopInfo();
    }

    /**
     * 获取门店商务合作信息
     *
     * @support  string $storeId 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBusinessCooperationInformation () {
        return self::getClass()->getBusinessCooperationInformation();
    }

    /**
     * 获取门店商务合作信息
     *
     * @support  string $store_id 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getpeopleInfo () {
        return self::getClass()->getpeopleInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'StoreInformatization\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'StoreInformatization\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}