<?php
namespace Mainto\Bridge\Invokes\ProjectKids\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeListByParams(array $params)
 * @method testCreateByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取kids全部门店
     *
     * @support  string $storeType 门店类型 
     * @support  string $storeName 门店名称 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeList () {
        return self::getClass()->storeList();
    }

    /**
     * 获取kids全部门店
     *
     * @support  string $store_id 门店名称 
     * @support  string $name 门店名称 
     * @support  string $store_type 门店类型 
     * @support  string $store_type_name 门店类型名称 
     * @support  string $store_level 门店等级 
     * @support  string $store_level_name 门店等级名称 
     * @support  string $market_mature_info 商场成熟度 
     * @support  string $city_id 所属城市编码 
     * @support  string $city_name 所属城市 
     * @support  string $city_level 城市级别编码 
     * @support  string $market_id 所属商场编码 
     * @support  string $market_name 所属商场名称 
     * @support  string $business_district 所属商圈 
     * @support  string $market_address 商场地址 
     * @support  string $area 所属区域 
     * @support  string $regional_manager 区域经理 
     * @support  string $city_manager 城市经理 
     * @support  string $development_experts 拓展专家 
     * @support  string $plan_start_time 预计开业时间 
     * @support  string $status 项目状态 
     * @support  string $delay_reason 延迟开业原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreate () {
        return self::getClass()->testCreate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'StoreInformatization\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'StoreInformatization\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}