<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCloudStreamInfoByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 云端流水详情
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo (int $cloudStreamId) {
        return self::getClass()->getCloudStreamInfo([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 获取订单详情(带云图详情)
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (int $orderId) {
        return self::getClass()->getOrderInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $orderNum 订单号 
     * @support  string $userName 顾客姓名 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 获取Host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}