<?php
namespace Mainto\Bridge\Invokes\ProjectKids\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrdersByParams(array $params)
 * @method createRefundByParams(array $params)
 * @method searchRefundsByParams(array $params)
 * @method getRefundDetailByParams(array $params)
 * @method passRefundByParams(array $params)
 * @method refundRejectByParams(array $params)
 */
class CouponOrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询订单
     *
     * @support  string $userPhone 手机号 
     * @support  int $size 记录数 
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrders () {
        return self::getClass()->searchOrders();
    }

    /**
     * 创建退款
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  string $note 退款备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRefund () {
        return self::getClass()->createRefund();
    }

    /**
     * 退款列表
     *
     * @support  string $queryType 查询类型，create_time:按创建时间 refund_time:按退款时间 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 订单状态，详见：CouponOrderRefundStatusEnum 
     * @support  string $orderNo 订单号 
     * @support  string $userPhone 手机号 
     * @support  int $page 页数 [Original type uint] 
     * @support  int $pageSize 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function searchRefunds () {
        return self::getClass()->searchRefunds();
    }

    /**
     * 退款详情
     *
     * @support  int $refundId 退款记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRefundDetail () {
        return self::getClass()->getRefundDetail();
    }

    /**
     * 通过退款
     *
     * @support  int $refundId 退款记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function passRefund () {
        return self::getClass()->passRefund();
    }

    /**
     * 拒绝退款
     *
     * @support  int $refundId 退款记录id [ require true ]
     * @support  string $rejectReason 拒绝原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundReject () {
        return self::getClass()->refundReject();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Admin\CouponOrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Admin\CouponOrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}