<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryWaitReviewListByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method getKidsProductListByParams(array $params)
 * @method getKpsWorkByParams(array $params)
 * @method getKpsOrderByParams(array $params)
 * @method sendKidsOrderCompleteNotifyByParams(array $params)
 * @method sendTakePhotoNotifyByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $name 姓名 
     * @support  string $phone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitReviewList () {
        return self::getClass()->queryWaitReviewList();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * 发送看片通知
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 审核历史列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory();
    }

    /**
     * 获取看片师看片历史记录列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  string $searchType 门店看片\个人看片 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 获取kids产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsProductList () {
        return self::getClass()->getKidsProductList();
    }

    /**
     * 获取看片师工作量
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getKpsWork () {
        return self::getClass()->getKpsWork();
    }

    /**
     * 获取看片师工作量
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getKpsOrder () {
        return self::getClass()->getKpsOrder();
    }

    /**
     * kids录入工作量完成事件
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $staffIds 化妆师ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKidsOrderCompleteNotify () {
        return self::getClass()->sendKidsOrderCompleteNotify();
    }

    /**
     * 发送取片通知
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTakePhotoNotify () {
        return self::getClass()->sendTakePhotoNotify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}