<?php
namespace Mainto\Bridge\Invokes\ProjectKids\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method bindByParams(array $params)
 * @method getPhotoByParams(array $params)
 * @method setPaidOrderByParams(array $params)
 * @method discountByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  array $detail 订单详情(商品&amp;服务详情) [ require true ]
     * @support  float $oriMoney 原始价格 [Original type unsignedDouble] [ require true ]
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  float $productCardDeductionMoney 产品卡折扣金额 [Original type unsignedDouble] 
     * @support  float $productCardId 产品卡id [Original type unsignedDouble] 
     * @support  array $productDiscountIds 组合优惠id 
     * @support  string $type 订单类型 [ require true ]
     * @support  string $outside_city 拍摄城市 
     * @support  string $outside_address 拍摄详细地址 
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $storeId 门店id [ require true ]
     * @support  int $channel 渠道号 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取订单列表
     *
     * @support  string $status 订单状态-total:全部,wait:待拍摄,today:当日拍摄,complete:已完成,close:已关闭 [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 取消未支付订单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 修改预约时间
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @support  string $note 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * 绑定订单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 下载原片
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhoto () {
        return self::getClass()->getPhoto();
    }

    /**
     * 支付订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $orderDiffId diffid [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  string $diffType difftype [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaidOrder () {
        return self::getClass()->setPaidOrder();
    }

    /**
     * 获取门店折扣详情
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function discount () {
        return self::getClass()->discount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}