<?php
namespace Mainto\Bridge\Invokes\ProjectKids\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductsByStoreByParams(array $params)
 * @method productDiscountByParams(array $params)
 * @method getDetailListByCategoryIdByParams(array $params)
 * @method detailByParams(array $params)
 * @method clearCacheByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByStore (int $storeId) {
        return self::getClass()->getProductsByStore([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取门店折扣详情
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDiscount () {
        return self::getClass()->productDiscount();
    }

    /**
     * 获取一个门店下某个类目所有的产品
     *
     * @support  int $categoryId 类目 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailListByCategoryId () {
        return self::getClass()->getDetailListByCategoryId();
    }

    /**
     * 获取产品详情
     *
     * @support  int $productId 产品id [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 清除缓存(test)
     *
     * @support  string $cacheKey key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearCache () {
        return self::getClass()->clearCache();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'User\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'User\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}