<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method photoDetailByParams(array $params)
 * @method getPhotoListByParams(array $params)
 */
class GuestPhotoPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 客片池详情
     *
     * @support  int $photoId 照片id [ require true ]
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoDetail () {
        return self::getClass()->photoDetail();
    }

    /**
     * 客片池列表
     *
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  string $orderNum 订单号 
     * @support  string $userName 姓名 
     * @support  string $phone 手机号 
     * @support  array $storeIds 门店id 
     * @support  array $productIds 产品ids 
     * @support  array $staffs 伙伴信息 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoList () {
        return self::getClass()->getPhotoList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'GuestPhotoPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'GuestPhotoPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}