<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addNewPaymentByParams(array $params)
 * @method getStorePayTypeByParams(array $params)
 * @method closeByParams(array $params)
 * @method callBackByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建支付单
     *
     * @support  string $orderNum 订单号 
     * @support  int $orderType 订单类型 
     * @support  float $money 需要支付的金额(单位为元) [Original type unsignedDouble] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewPayment () {
        return self::getClass()->addNewPayment();
    }

    /**
     * 获取门店允许的支付类型
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorePayType () {
        return self::getClass()->getStorePayType();
    }

    /**
     * 关闭支付
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callBack () {
        return self::getClass()->callBack();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}