<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrderByParams(array $params)
 * @method getOrderTakeTimeByParams(array $params)
 * @method pushOrderToCameramanByParams(array $params)
 * @method getOrderOnlineListByParams(array $params)
 * @method revokeCloudStreamByParams(array $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method submitToCloudByParams(array $params)
 * @method getPhotographicNumByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method revokeOrderByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method syncKidsOrderByParams(array $params)
 * @method sysCancelOrderByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄订单查询
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $userName 顾客姓名 [ require true ]
     * @param  string $userPhone 手机号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrder (string $orderNum = '', string $userName = '', string $userPhone = '') {
        return self::getClass()->searchOrder([
            "orderNum" => $orderNum,
            "userName" => $userName,
            "userPhone" => $userPhone,
        ]);
    }

    /**
     * 获取订单取片时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderTakeTime (int $orderId) {
        return self::getClass()->getOrderTakeTime([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 订单添加至摄影师
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushOrderToCameraman (string $orderNum) {
        return self::getClass()->pushOrderToCameraman([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 摄影师接单列表查询
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnlineList () {
        return self::getClass()->getOrderOnlineList();
    }

    /**
     * 撤回照片(流水维度)
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeCloudStream (int $cloudStreamId) {
        return self::getClass()->revokeCloudStream([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 云端流水详情
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo (int $cloudStreamId) {
        return self::getClass()->getCloudStreamInfo([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 提交至云端
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  int $serviceId 服务id 
     * @support  array $retouchClaim 修片要求 
     * @support  string $takeTime 取片时间 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $dresserNote 化妆备注 
     * @support  string $photographyNote 摄影备注 
     * @support  string $retouchNote 修片备注 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submitToCloud () {
        return self::getClass()->submitToCloud();
    }

    /**
     * 获取摄影数量
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  int $service_id 服务id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getPhotographicNum (int $product_id, int $service_id = 0) {
        return self::getClass()->getPhotographicNum([
            "product_id" => $product_id,
            "service_id" => $service_id,
        ]);
    }

    /**
     * 获取订单详情(带云图详情)
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (int $orderId) {
        return self::getClass()->getOrderInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $orderNum 订单号 
     * @support  string $userName 顾客姓名 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 撤回照片(订单维度)
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeOrder (int $orderId) {
        return self::getClass()->revokeOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取Host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 批量获取流水详情(通过流水id)
     *
     * @support  array $cloud_stream_ids 流水ids 
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfoByIds () {
        return self::getClass()->batchGetStreamInfoByIds();
    }

    /**
     * 同步修改kids订单
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $userName 用户姓名 [ require true ]
     * @param  string $userPhone 用户手机号 [ require true ]
     * @param  string $note 订单备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncKidsOrder (string $orderNum, string $userName = '', string $userPhone = '', string $note = '') {
        return self::getClass()->syncKidsOrder([
            "orderNum" => $orderNum,
            "userName" => $userName,
            "userPhone" => $userPhone,
            "note" => $note,
        ]);
    }

    /**
     * 摄影师取消的接单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sysCancelOrder () {
        return self::getClass()->sysCancelOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}