<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryWaitReviewListByParams(array $params)
 * @method bindCheckerByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method reviewByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method getCheckerUnReadStreamCountByParams(array $params)
 * @method changeStreamStateByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method cleanLostOrderByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method secondRetoucherTakeOrderByParams(array $params)
 * @method storeWatchSignByParams(array $params)
 * @method cancelLineUpByParams(array $params)
 * @method bindSecondRetoucherByParams(array $params)
 * @method mySecondOrderByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method getKidsProductListByParams(array $params)
 * @method getKpsWorkByParams(array $params)
 * @method storeSignNumberByParams(array $params)
 * @method sendKidsOrderCompleteNotifyByParams(array $params)
 * @method sendTakePhotoNotifyByParams(array $params)
 * @method changeTakeTypeByParams(array $params)
 * @method hangUpOrderByParams(array $params)
 * @method cancelHangUpOrderByParams(array $params)
 * @method getHangUpOrderByParams(array $params)
 * @method updateStreamByParams(array $params)
 * @method hookCloudFinishKidsStreamByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $name 姓名 
     * @support  string $phone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitReviewList () {
        return self::getClass()->queryWaitReviewList();
    }

    /**
     * 绑定审核人id
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 提交审核
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  int $score 评价 [ require true ]
     * @support  array $photo 照片 
     * @support  string $note 评语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function review () {
        return self::getClass()->review();
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * （论询）获取未读流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckerUnReadStreamCount () {
        return self::getClass()->getCheckerUnReadStreamCount();
    }

    /**
     * (定时任务:)修改未审核完成的流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStreamState () {
        return self::getClass()->changeStreamState();
    }

    /**
     * (首次登录:)提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 消息已读，清空缓存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanLostOrder () {
        return self::getClass()->cleanLostOrder();
    }

    /**
     * 发送看片通知
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 审核历史列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory();
    }

    /**
     * 看片师接单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function secondRetoucherTakeOrder () {
        return self::getClass()->secondRetoucherTakeOrder();
    }

    /**
     * 门店签到
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeWatchSign () {
        return self::getClass()->storeWatchSign();
    }

    /**
     * 门店取消排队
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelLineUp () {
        return self::getClass()->cancelLineUp();
    }

    /**
     * 绑定看片师id
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $token token [ require true ]
     * @support  int $staffId 看片师id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSecondRetoucher () {
        return self::getClass()->bindSecondRetoucher();
    }

    /**
     * 我的看片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mySecondOrder () {
        return self::getClass()->mySecondOrder();
    }

    /**
     * 提交最终成片
     *
     * @support  string $streamNo 流水号 
     * @support  array $photoData 照片数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitFinalPhoto () {
        return self::getClass()->submitFinalPhoto();
    }

    /**
     * 获取看片师看片历史记录列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  string $searchType 门店看片\个人看片 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 获取kids产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsProductList () {
        return self::getClass()->getKidsProductList();
    }

    /**
     * 获取看片师工作量
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getKpsWork () {
        return self::getClass()->getKpsWork();
    }

    /**
     * 门店签到排号
     *
     * @support  string $orderNums 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeSignNumber () {
        return self::getClass()->storeSignNumber();
    }

    /**
     * kids录入工作量完成事件
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $staffIds 化妆师ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKidsOrderCompleteNotify () {
        return self::getClass()->sendKidsOrderCompleteNotify();
    }

    /**
     * 发送取片通知
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTakePhotoNotify () {
        return self::getClass()->sendTakePhotoNotify();
    }

    /**
     * (定时任务:)修改的流水取片时间
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeTakeType () {
        return self::getClass()->changeTakeType();
    }

    /**
     * 看片挂起订单
     *
     * @support  string $token token [ require true ]
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangUpOrder () {
        return self::getClass()->hangUpOrder();
    }

    /**
     * 结束挂起
     *
     * @support  string $token token [ require true ]
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelHangUpOrder () {
        return self::getClass()->cancelHangUpOrder();
    }

    /**
     * 获取看片挂起订单列表
     *
     * @support  string $token token [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHangUpOrder () {
        return self::getClass()->getHangUpOrder();
    }

    /**
     * 修改流水状态
     *
     * @support  string $token token [ require true ]
     * @support  string $streamNum 流水号 [ require true ]
     * @support  array $streamContent 流水内容 [ require true ]
     * @support  bool $withOrder 是否需要修改订单 [ require true ]
     * @support  array $orderContent 订单内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStream () {
        return self::getClass()->updateStream();
    }

    /**
     * 接收云端流水完成事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudFinishKidsStream (string $stream_num) {
        return self::getClass()->hookCloudFinishKidsStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}