<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryWaitReviewListByParams(array $params)
 * @method bindCheckerByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method reviewByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method newStreamNotifyByParams(array $params)
 * @method changeStreamStateByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method secondRetoucherTakeOrderByParams(array $params)
 * @method storeWatchSignByParams(array $params)
 * @method bindSecondRetoucherByParams(array $params)
 * @method mySecondOrderByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $name 姓名 
     * @support  string $phone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitReviewList () {
        return self::getClass()->queryWaitReviewList();
    }

    /**
     * 绑定审核人id
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 提交审核
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  int $score 评价 [ require true ]
     * @support  array $photo 照片 
     * @support  string $note 评语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function review () {
        return self::getClass()->review();
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * (论询)新流水通知（未完成）
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function newStreamNotify () {
        return self::getClass()->newStreamNotify();
    }

    /**
     * (定时任务:)修改未审核完成的流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStreamState () {
        return self::getClass()->changeStreamState();
    }

    /**
     * (首次登录:)提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 发送看片通知
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 审核历史列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory();
    }

    /**
     * 看片师接单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function secondRetoucherTakeOrder () {
        return self::getClass()->secondRetoucherTakeOrder();
    }

    /**
     * 门店签到
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeWatchSign () {
        return self::getClass()->storeWatchSign();
    }

    /**
     * 绑定看片师id
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSecondRetoucher () {
        return self::getClass()->bindSecondRetoucher();
    }

    /**
     * 我的看片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function mySecondOrder () {
        return self::getClass()->mySecondOrder();
    }

    /**
     * 提交最终成片
     *
     * @support  string $streamNo 流水号 
     * @support  array $photoData 照片数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitFinalPhoto () {
        return self::getClass()->submitFinalPhoto();
    }

    /**
     * 获取看片师看片历史记录列表
     *
     * @support  string $orderNo 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}