<?php
namespace Mainto\Bridge\Invokes\ProjectKids\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method bindByParams(array $params)
 * @method availableListByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得用户已有的优惠券
     *
     * @support  string $status 优惠券状态  require false
     * @support  string $type 优惠券状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $code 兑换码 [ require true ]
     * @support  string $type 优惠券状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 获取用户下单可用优惠券(含未失效但不可用)
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function availableList () {
        return self::getClass()->availableList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'User\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'User\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}