<?php
namespace Mainto\Bridge\Invokes\ProjectKids;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryWaitReviewListByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method getKidsProductListByParams(array $params)
 * @method getKpsWorkByParams(array $params)
 * @method getKpsOrderByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $orderNo 订单号 require false
     * @support  string $name 姓名 require false
     * @support  string $phone 手机号 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryWaitReviewList () {
        return self::getClass()->queryWaitReviewList();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * 获取kids产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsProductList () {
        return self::getClass()->getKidsProductList();
    }

    /**
     * 获取看片师工作量
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKpsWork () {
        return self::getClass()->getKpsWork();
    }

    /**
     * 获取看片师工作量
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKpsOrder () {
        return self::getClass()->getKpsOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectKids', 'SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}