<?php
namespace Mainto\Bridge\Invokes\ProjectInfoConstruction\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method finishMissionByParams(array $params)
 * @method closeMissionByParams(array $params)
 * @method updateLicenseByParams(array $params)
 * @method updateInsuranceByParams(array $params)
 */
class StoreUpdate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 完成门店任务
     *
     * @support  string $id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishMission () {
        return self::getClass()->finishMission();
    }

    /**
     * 更新门店任务未完成
     *
     * @support  string $id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMission () {
        return self::getClass()->closeMission();
    }

    /**
     * 更新营业执照数据
     *
     * @support  int $id _id [ require true ]
     * @support  string $businessLicensePlace 营业执照正本存放地 
     * @support  string $copyBusinessLicensePlace 营业执照副本存放地 
     * @support  string $officialPlace 公章存放地 [ require true ]
     * @support  string $contractPlace 合同章存放地 [ require true ]
     * @support  string $financialPlace 财务章存放地 [ require true ]
     * @support  string $legalPlace 法人章存放地 [ require true ]
     * @support  string $opUpdatePeoName 更新人姓名 [ require true ]
     * @support  string $opUpdatePeoID 更新人id [ require true ]
     * @support  string $opUpdatePeoLoginName 更新人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateLicense () {
        return self::getClass()->updateLicense();
    }

    /**
     * 更新保险数据
     *
     * @support  array $contents _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateInsurance () {
        return self::getClass()->updateInsurance();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectInfoConstruction', 'StoreInformatization\StoreUpdate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectInfoConstruction', 'StoreInformatization\StoreUpdate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}