<?php
namespace Mainto\Bridge\Invokes\ProjectInfoConstruction\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method finishMissionByParams(array $params)
 * @method closeMissionByParams(array $params)
 * @method updateLicenseByParams(array $params)
 * @method updateInsuranceByParams(array $params)
 * @method updateReservePeopleByParams(array $params)
 * @method updateByParams(array $params)
 * @method finishDecorationsByParams(array $params)
 * @method delayedOpeningByParams(array $params)
 */
class StoreUpdate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 完成门店任务
     *
     * @support  string $id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishMission () {
        return self::getClass()->finishMission();
    }

    /**
     * 更新门店任务未完成
     *
     * @support  string $id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMission () {
        return self::getClass()->closeMission();
    }

    /**
     * 更新营业执照数据
     *
     * @support  int $id _id [ require true ]
     * @support  string $businessLicensePlace 营业执照正本存放地 
     * @support  string $copyBusinessLicensePlace 营业执照副本存放地 
     * @support  string $officialPlace 公章存放地 [ require true ]
     * @support  string $contractPlace 合同章存放地 [ require true ]
     * @support  string $financialPlace 财务章存放地 [ require true ]
     * @support  string $legalPlace 法人章存放地 [ require true ]
     * @support  string $opUpdatePeoName 更新人姓名 [ require true ]
     * @support  string $opUpdatePeoID 更新人id [ require true ]
     * @support  string $opUpdatePeoLoginName 更新人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateLicense () {
        return self::getClass()->updateLicense();
    }

    /**
     * 更新保险数据
     *
     * @support  array $contents _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateInsurance () {
        return self::getClass()->updateInsurance();
    }

    /**
     * 更新人员储备信息
     *
     * @support  string $id _id [ require true ]
     * @support  string $jobName 岗位名称 [ require true ]
     * @support  string $jobCode 岗位编码 [ require true ]
     * @support  string $contactAmount 人数 [ require true ]
     * @support  string $contactName 联系人 [ require true ]
     * @support  string $contactLogin 联系人账号 
     * @support  string $contactId 联系人ID 
     * @support  string $phone 联系方式 [ require true ]
     * @support  string $email 邮箱 [ require true ]
     * @support  string $adminName 管理员 [ require true ]
     * @support  string $adminId 管理员id [ require true ]
     * @support  string $adminAccount 管理员账号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateReservePeople () {
        return self::getClass()->updateReservePeople();
    }

    /**
     * 更新施工任务情况说明
     *
     * @support  string $id _id [ require true ]
     * @support  string $situationExplain 当前情况说明 [ require true ]
     * @support  string $adminName 管理员 [ require true ]
     * @support  string $adminId 管理员id [ require true ]
     * @support  string $adminAccount 管理员账号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 完成施工任务
     *
     * @support  string $id _id [ require true ]
     * @support  string $adminName 管理员 [ require true ]
     * @support  string $adminId 管理员id [ require true ]
     * @support  string $adminAccount 管理员账号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishDecorations () {
        return self::getClass()->finishDecorations();
    }

    /**
     * 延迟开业
     *
     * @support  string $storeId 门店编码 [ require true ]
     * @support  string $delayTime 时间 [ require true ]
     * @support  string $reason 原因 [ require true ]
     * @support  string $adminName 管理员 [ require true ]
     * @support  string $adminId 管理员id [ require true ]
     * @support  string $adminAccount 管理员账号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delayedOpening () {
        return self::getClass()->delayedOpening();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectInfoConstruction', 'StoreInformatization\StoreUpdate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectInfoConstruction', 'StoreInformatization\StoreUpdate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}