<?php
namespace Mainto\Bridge\Invokes\ProjectInfoConstruction\StoreInformatization;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method testCreateByParams(array $params)
 * @method testCreateDesignByParams(array $params)
 * @method testCreateShopByParams(array $params)
 * @method testCreateShopCooInfoByParams(array $params)
 * @method testCreateShopDepositByParams(array $params)
 * @method testCreateShopRentsByParams(array $params)
 * @method testCreateMarketPeopleByParams(array $params)
 * @method testCreateStaffByParams(array $params)
 * @method testCreatePeopleReserveByParams(array $params)
 * @method testCreateOpenStoreTasksByParams(array $params)
 * @method testCreateStoreDecorationsByParams(array $params)
 * @method testCreateUploadInfoByParams(array $params)
 * @method testCreateProcessInfoByParams(array $params)
 */
class StoreCreate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * test创建门店
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $StoreTypeName 门店类型名称 
     * @support  string $StoreTypeCode 门店类型编码 
     * @support  string $CityName 所属城市 
     * @support  string $CityCode 所属城市编码 
     * @support  string $CityLevel 城市级别 
     * @support  string $BusinessDistrictName 所属商场名称 
     * @support  string $BusinessDistrictCode 所属商场编码 
     * @support  string $BusinessDistrictAddress 所属商场地址 
     * @support  string $LeaseArea 门店面积 
     * @support  string $ShoppingMallsMaturity 商场成熟度 
     * @support  string $RegionName 所属区域 
     * @support  string $RegionCode 所属区域编码 
     * @support  string $RegionID 所属区域ID 
     * @support  string $RegionManagerName 区域经理 
     * @support  string $RegionManagerLoginName 区域经理编码 
     * @support  string $RegionManagerID 区域经理ID 
     * @support  string $CityManagerName 城市经理 
     * @support  string $CityManagerLoginName 城市经理编码 
     * @support  string $CityManagerID 城市经理ID 
     * @support  string $ProjectState 项目状态 
     * @support  string $EstimatedOpeningTime 预计开业时间 
     * @support  string $DelayedOpenReason 延迟开业原因 
     * @support  string $BusinessConfirmationProcessName 流程名称 
     * @support  string $BusinessConfirmationIncident 流程实例 
     * @support  string $BusinessConfirmationSN 流程单号 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreate () {
        return self::getClass()->testCreate();
    }

    /**
     * test创建门店设计图
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $UploadClaim 附件需求 
     * @support  string $UploadName 相关附件 
     * @support  string $UploadCode 相关附件编码 
     * @support  string $UploadID 相关附件ID 
     * @support  string $UploadVersion 相关附件版本 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateDesign () {
        return self::getClass()->testCreateDesign();
    }

    /**
     * test创建门店店铺信息
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $SeatingFloor 落位楼层 
     * @support  string $ShopNumber 商铺号码 
     * @support  string $CashierMethod 收银方式 
     * @support  string $MonthlySalesEstimate 月销售预估 
     * @support  string $StoreStudioConfiguration 门店影棚配置 
     * @support  string $StoreDressingTableConfiguration 门店妆台配置 
     * @support  string $StoreLaterStageConfiguration 门店后期配置 
     * @support  string $PetPhotoShoot 能否拍摄宠物照 
     * @support  string $ShoppingMallSpecialRequirements 商场特殊要求 
     * @support  string $ApplyCpnName 所属公司 
     * @support  string $ApplyCpnCode 所属公司编码 
     * @support  string $ApplyCpnID 所属公司ID 
     * @support  string $NewStoreProposeProcessName 流程名称 
     * @support  string $NewStoreProposeIncident 流程实例 
     * @support  string $NewStoreProposeSN 流程单号 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShop () {
        return self::getClass()->testCreateShop();
    }

    /**
     * test创建门店商务合作信息
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $LeasePeriodBegin 租赁开始日期 
     * @support  string $LeasePeriodEnd 租赁结束日期 
     * @support  string $DecorationRentFreePeriod 装修免租期 
     * @support  string $OperatingRentFreePeriod 经营免租期 
     * @support  string $LeaseMethod 租赁方式 
     * @support  string $LeaseConditions 租赁条件 
     * @support  string $Deduction 扣点 
     * @support  string $Exclusive 排他 
     * @support  string $AdvertisingFee 广告位 
     * @support  string $PaymentCycle 缴费周期 
     * @support  string $DepositAmount 押金金额 
     * @support  string $PropertymanagementFee 物业管理费 
     * @support  string $PromotionFee 推广费 
     * @support  string $BusinessConfirmationProcessName 流程名称 
     * @support  string $BusinessConfirmationIncident 流程实例 
     * @support  string $BusinessConfirmationSN 流程单号 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShopCooInfo () {
        return self::getClass()->testCreateShopCooInfo();
    }

    /**
     * test创建门店定金
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $DS_DepositName 押金名称 
     * @support  string $DS_DepositAmount 押金金额 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShopDeposit () {
        return self::getClass()->testCreateShopDeposit();
    }

    /**
     * test创建门店租金
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $RB_PaymentCycle 租金明细 
     * @support  string $RB_RentAmount 岗位编码 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateShopRents () {
        return self::getClass()->testCreateShopRents();
    }

    /**
     * test创建商场联系人
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $SC_JobName 岗位名称 
     * @support  string $SC_JobCode 岗位编码 
     * @support  string $SC_ContactName 联系人 
     * @support  string $SC_ContactLogin 联系人账号 
     * @support  string $SC_ContactID 联系人ID 
     * @support  string $SC_Phone 联系方式 
     * @support  string $SC_Email 邮箱 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateMarketPeople () {
        return self::getClass()->testCreateMarketPeople();
    }

    /**
     * test创建门店员工
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $NSRC_JobName 岗位名称 
     * @support  string $NSRC_JobCode 岗位编码 
     * @support  string $NSRC_ContactName 联系人 
     * @support  string $NSRC_ContactLogin 联系人账号 
     * @support  string $NSRC_ContactID 联系人ID 
     * @support  string $NSRC_Phone 联系方式 
     * @support  string $NSRC_Email 邮箱 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateStaff () {
        return self::getClass()->testCreateStaff();
    }

    /**
     * test创建门店人员储备
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $CR_JobName 岗位名称 
     * @support  string $CR_JobCode 岗位编码 
     * @support  string $CR_ContactAmount 人数 
     * @support  string $CR_ContactName 联系人 
     * @support  string $CR_ContactLogin 联系人账号 
     * @support  string $CR_ContactID 联系人ID 
     * @support  string $CR_Phone 联系方式 
     * @support  string $CR_Email 邮箱 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreatePeopleReserve () {
        return self::getClass()->testCreatePeopleReserve();
    }

    /**
     * test创建新店开业任务
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $StoreTaskType 任务类型 
     * @support  string $StoreTaskList 任务清单 
     * @support  string $StoreTaskInfo 任务内容 
     * @support  string $BeginDateTime 开始日期 
     * @support  string $EndDateTime 结束日期 
     * @support  string $UploadName 相关附件 
     * @support  string $UploadCode 相关附件编码 
     * @support  string $UploadID 相关附件ID 
     * @support  string $TaskStauts 任务状态 
     * @support  string $ContactPeoName 联系对接人 
     * @support  string $ContactPeoID 联系对接人ID 
     * @support  string $ContactLoginName 联系对接人账号 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateOpenStoreTasks () {
        return self::getClass()->testCreateOpenStoreTasks();
    }

    /**
     * test创建新店施工任务进度
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $RenovationStage 所属阶段 
     * @support  string $CompleteTme 完成时间 
     * @support  string $SituationExplain 当前情况说明 
     * @support  string $UploadName 相关附件 
     * @support  string $UploadCode 相关附件编码 
     * @support  string $UploadID 相关附件ID 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateStoreDecorations () {
        return self::getClass()->testCreateStoreDecorations();
    }

    /**
     * test创建文件数据
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $UploadType 附件类别 
     * @support  string $UploadName 相关附件 
     * @support  string $UploadCode 相关附件地址编码 
     * @support  string $UploadID 相关附件ID 
     * @support  string $UploadVersion 相关附件版本 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateUploadInfo () {
        return self::getClass()->testCreateUploadInfo();
    }

    /**
     * test创建流程单据
     *
     * @support  string $StoreName 门店名称 
     * @support  string $StoreCode 门店编码 
     * @support  string $ProcessName 流程名称 
     * @support  string $Incident 流程实例 
     * @support  string $RecordSN 流程单号 
     * @support  string $ProcessUrl 流程地址 
     * @support  string $OpCreateDateTime 创建时间 
     * @support  string $OpCreatePeoName 创建人 
     * @support  string $OpCreatePeoID 创建人ID 
     * @support  string $OpCreatePeoLoginName 创建人账号 
     * @support  string $OpUpdateDateTime 更新时间 
     * @support  string $OpUpdatePeoName 更新人 
     * @support  string $OpUpdatePeoID 更新人ID 
     * @support  string $OpUpdatePeoLoginName 更新人账 
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCreateProcessInfo () {
        return self::getClass()->testCreateProcessInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectInfoConstruction', 'StoreInformatization\StoreCreate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectInfoConstruction', 'StoreInformatization\StoreCreate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}