<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-06 19:05:22
 */
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class FamilyShopCart
 */
class FamilyShopCart {
    private static string $serviceName = "ProjectGuideDomain";

    private static string $className = "ShopCart\\FamilyShopCart";

    /**
     * 加入购物车.family
     *
     */
    public static function saveShopCart (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\FamilyShopCartSaveCMD $familyShopCartSaveCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveShopCart($familyShopCartSaveCMD);
    }
    /**
     * 移出购物车.family
     *
     */
    public static function deleteShopCart (array $shopCartIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteShopCart(["shopCartIds" => $shopCartIds, ]);
    }
    /**
     * 获取购物车商品数量.family
     *
     */
    public static function getShopCartCount (int $cityId): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopCartCount(["cityId" => $cityId, ]);
    }
    /**
     * 获得购物车信息.family
     *
     */
    public static function getShopCartInfo (int $cityId): \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\ShopCartSetDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShopCartInfo(["cityId" => $cityId, ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\ShopCartSetDTO"
        );
    }
    /**
     * 获取产品类目的套餐购物车信息.family
     *
     */
    public static function getShopCartPackageInfo (int $cityId, int $categoryId, int $packageId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopCartPackageInfo(["cityId" => $cityId, "categoryId" => $categoryId, "packageId" => $packageId, ]);
    }
    /**
     * 获得购物车推荐套餐信息.family
     *
     */
    public static function getShopCartRecommendPackage (int $cityId): \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\RecommendPackageDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShopCartRecommendPackage(["cityId" => $cityId, ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\RecommendPackageDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}