<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCategoryProductsByStoreIdByParams(array $params)
 * @method getCategoryProductsByCityIdByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCityIdCmd $params)
 * @method getCategoryProductsByCategoryIdsByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCategoryIdsCmd $params)
 * @method getCategoryProductsByStoreIdV1ByParams(array $params)
 * @method getCategoryProductsByCityIdV1ByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCityIdCmd $params)
 * @method getCategoryProductsByCategoryIdsV1ByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCategoryIdsCmd $params)
 */
class HimoProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某个门店下某个类目所有的产品.预约端
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $appKey 客户端标识 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId, string $appKey = '') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByStoreId([
                            "storeId" => $storeId,
                            "categoryId" => $categoryId,
                            "appKey" => $appKey,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取某个城市下某个类目所有的产品.预约端
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCityIdCmd $categoryProductsByCityIdCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByCityId (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCityIdCmd $categoryProductsByCityIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByCityId($categoryProductsByCityIdCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO"
        );
    }


    /**
     * 获取某个城市下多个类目所有的产品.预约端
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCategoryIdsCmd $categoryProductsByCategoryIdsCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryProductsByCategoryIds (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCategoryIdsCmd $categoryProductsByCategoryIdsCmd) {
        return self::getClass()->getCategoryProductsByCategoryIds($categoryProductsByCategoryIdsCmd);
    }


    /**
     * 获取某个门店下某个类目所有的产品.预约端.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $appKey 客户端标识 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByStoreIdV1 (int $storeId, int $categoryId, string $appKey = '') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByStoreIdV1([
                            "storeId" => $storeId,
                            "categoryId" => $categoryId,
                            "appKey" => $appKey,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取某个城市下某个类目所有的产品.预约端.v1
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCityIdCmd $categoryProductsByCityIdCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByCityIdV1 (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCityIdCmd $categoryProductsByCityIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByCityIdV1($categoryProductsByCityIdCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO"
        );
    }


    /**
     * 获取某个城市下多个类目所有的产品.预约端.v1
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCategoryIdsCmd $categoryProductsByCategoryIdsCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryProductsByCategoryIdsV1 (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Product\CategoryProductsByCategoryIdsCmd $categoryProductsByCategoryIdsCmd) {
        return self::getClass()->getCategoryProductsByCategoryIdsV1($categoryProductsByCategoryIdsCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Product\HimoProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Product\HimoProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}