<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenPackageUpByParams(array $params)
 * @method listenPackageDownByParams(array $params)
 * @method listenPackageUpdateByParams(array $params)
 * @method listenPackageUpdateDelayByParams(array $params)
 * @method listenPackageStoreFlushByParams(array $params)
 */
class ProductPackageMessageQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 套餐上架消息
     *
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageUp (int $packageId) {
        return self::getClass()->listenPackageUp([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 套餐下架消息
     *
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageDown (int $packageId) {
        return self::getClass()->listenPackageDown([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 套餐更新消息,底层处理产品更新时也会发出包含该产品的套餐更新事件
     *
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageUpdate (int $packageId) {
        return self::getClass()->listenPackageUpdate([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 套餐更新消息.platform
     *
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageUpdateDelay (int $packageId) {
        return self::getClass()->listenPackageUpdateDelay([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 门店套餐刷新.platform
     *
     * @param  array $priceAreaIds 套餐价格区ids [ require true ]
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageStoreFlush (array $priceAreaIds, int $packageId) {
        return self::getClass()->listenPackageStoreFlush([
            "priceAreaIds" => $priceAreaIds,
            "packageId" => $packageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'MessageQueue\ProductPackageMessageQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'MessageQueue\ProductPackageMessageQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}