<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCategoryProductsByCityIdByParams(array $params)
 * @method getCategoryProductsByStoreIdByParams(array $params)
 * @method getCategoryProductsByCategoryIdsByParams(array $params)
 */
class FamilyProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某个城市下某个类目所有的产品.family
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryProductsByCityId (int $cityId, int $categoryId) {
        return self::getClass()->getCategoryProductsByCityId([
            "cityId" => $cityId,
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 获取某个门店下某个类目所有的产品.family
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId) {
        return self::getClass()->getCategoryProductsByStoreId([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 获取某个城市下多个类目所有的产品.family
     *
     * @param  array $categoryIds 类目ids [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryProductsByCategoryIds (int $cityId, array $categoryIds) {
        return self::getClass()->getCategoryProductsByCategoryIds([
            "cityId" => $cityId,
            "categoryIds" => $categoryIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Product\FamilyProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Product\FamilyProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}