<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreInfoByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Store\StoreInfoGetCMD $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Store\StoreInfoGetCMD $storeInfoGetCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Store\StoreInfoDTO
     */
    public static function getStoreInfo (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Store\StoreInfoGetCMD $storeInfoGetCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreInfo($storeInfoGetCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Store\StoreInfoDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}