<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenCampaignIndexFlushByParams(array $params)
 */
class CampaignMessageQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听承接页Index刷新
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @param  string $versionStatus 活动模版状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenCampaignIndexFlush (int $campaignId, string $versionStatus) {
        return self::getClass()->listenCampaignIndexFlush([
            "campaignId" => $campaignId,
            "versionStatus" => $versionStatus,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'MessageQueue\CampaignMessageQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'MessageQueue\CampaignMessageQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}