<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\ProductPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHimoPackageInfoByCityIdByParams(array $params)
 */
class HimoProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取城市下某个套餐的详情信息.himo
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  int $packageId 套餐Id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductPackageDTO
     */
    public static function getHimoPackageInfoByCityId (int $cityId, int $packageId, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHimoPackageInfoByCityId([
                            "cityId" => $cityId,
                            "packageId" => $packageId,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductPackageDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'ProductPackage\HimoProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'ProductPackage\HimoProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}