<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenProductByParams(array $params)
 * @method listenCategoryByParams(array $params)
 * @method listenChangePriceAreaWithStoreByParams(array $params)
 * @method listenServiceUpdateByParams(array $params)
 * @method listenChangeBlacklistByParams(array $params)
 * @method listenChangeProductWithPriceByParams(array $params)
 */
class ProductMessageQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 缓存类型
     * 1、产品信息更改
     * 影响:
     * 1. 产品树价格区缓存
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProduct (int $productId) {
        return self::getClass()->listenProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 编辑产品组通知
     *
     * @param  int $categoryId 产品组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenCategory (int $categoryId) {
        return self::getClass()->listenCategory([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 价格区和门店关联变更
     *
     * @param  array $storeIds 门店数组 [ require true ]
     * @param  int $priceAreaId 价格区id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenChangePriceAreaWithStore (array $storeIds, int $priceAreaId) {
        return self::getClass()->listenChangePriceAreaWithStore([
            "storeIds" => $storeIds,
            "priceAreaId" => $priceAreaId,
        ]);
    }

    /**
     * 产品服务变更
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenServiceUpdate (int $productId) {
        return self::getClass()->listenServiceUpdate([
            "productId" => $productId,
        ]);
    }

    /**
     * 产品禁用门店通知
     *
     * @param  array $productIds 产品Ids [ require true ]
     * @param  array $storeIds 门店Ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenChangeBlacklist (array $productIds, array $storeIds) {
        return self::getClass()->listenChangeBlacklist([
            "productIds" => $productIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 产品和价格变更通知
     *
     * @param  int $productId 产品id [ require true ]
     * @param  int $priceId 价格id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenChangeProductWithPrice (int $productId, int $priceId) {
        return self::getClass()->listenChangeProductWithPrice([
            "productId" => $productId,
            "priceId" => $priceId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'MessageQueue\ProductMessageQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'MessageQueue\ProductMessageQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}