<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenCatalogueChangeByParams(array $params)
 * @method listenCatalogueListChangeByParams(array $params)
 */
class CatalogueMessageQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听全部产品分类变更
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function listenCatalogueChange () {
        return self::getClass()->listenCatalogueChange();
    }

    /**
     * 监听全部产品配置变更
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function listenCatalogueListChange () {
        return self::getClass()->listenCatalogueListChange();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'MessageQueue\CatalogueMessageQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'MessageQueue\CatalogueMessageQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}