<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Campaign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCampaignDetailByParams(array $params)
 */
class Campaign {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动模版详情
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @param  string $versionStatus 活动模版状态 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Campaign\CampaignDTO
     */
    public static function getCampaignDetail (int $campaignId, string $versionStatus = 'up') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCampaignDetail([
                            "campaignId" => $campaignId,
                            "versionStatus" => $versionStatus,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Campaign\CampaignDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Campaign\Campaign');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Campaign\Campaign');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}