<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\ProductPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPackageListByCityIdByParams(array $params)
 * @method getHimoPackageInfoByCityIdByParams(array $params)
 * @method getHimoSubPackageListByCityIdByParams(array $params)
 */
class HimoProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某个城市可展示的套餐列表.himo
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductPackageDTO[]
     */
    public static function getPackageListByCityId (int $cityId, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPackageListByCityId([
                            "cityId" => $cityId,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductPackageDTO[]"
        );
    }

    /**
     * 获取城市下某个套餐的详情信息.himo
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  int $packageId 套餐Id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductPackageDTO
     */
    public static function getHimoPackageInfoByCityId (int $cityId, int $packageId, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHimoPackageInfoByCityId([
                            "cityId" => $cityId,
                            "packageId" => $packageId,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductPackageDTO"
        );
    }

    /**
     * 获取某些产品组/产品关联的子套餐信息.himo
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  string $module 产品模块 [ require true ]
     * @param  array $ids 产品ids/产品组ids [ require true ]
     * @param  string $type photographyCategory/photographyProduct [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductSubPackageDTO[]
     */
    public static function getHimoSubPackageListByCityId (int $cityId, string $module, array $ids, string $type) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHimoSubPackageListByCityId([
                            "cityId" => $cityId,
                            "module" => $module,
                            "ids" => $ids,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\HimoProductSubPackageDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'ProductPackage\HimoProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'ProductPackage\HimoProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}