<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-30 11:13:38
 */
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductMessageQueue
 */
class ProductMessageQueue {
    private static string $serviceName = "ProjectGuideDomain";

    private static string $className = "MessageQueue\\ProductMessageQueue";

    /**
     * 编辑产品通知
     * @return  bool
    */
    public static function listenProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProduct(["productId" => $productId]);
    }
    /**
     * 编辑产品组通知
     * @return  bool
    */
    public static function listenCategory (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenCategory(["categoryId" => $categoryId]);
    }
    /**
     * 价格区和门店关联变更
     * @return  bool
    */
    public static function listenChangePriceAreaWithStore (array $storeIds, int $priceAreaId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangePriceAreaWithStore(["storeIds" => $storeIds, "priceAreaId" => $priceAreaId]);
    }
    /**
     * 产品服务变更
     * @return  bool
    */
    public static function listenServiceUpdate (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenServiceUpdate(["productId" => $productId]);
    }
    /**
     * 产品禁用门店通知
     * @return  bool
    */
    public static function listenChangeBlacklist (array $productIds, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangeBlacklist(["productIds" => $productIds, "storeIds" => $storeIds]);
    }
    /**
     * 产品和价格变更通知
     * @return  bool
    */
    public static function listenChangeProductWithPrice (int $productId, int $priceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenChangeProductWithPrice(["productId" => $productId, "priceId" => $priceId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}