<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-08 15:45:53
 */
namespace Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Config;

class PageResourceDTO {
    /**
     * @var  int
     * 点位ID
     * validation: 
     */
    public int $pointId;
    /**
     * @var  string
     * 支持的资源类型, 参考ResourceTypeV2Enum枚举值
     * validation: 
     */
    public string $type;
    /**
     * @var  int
     * 满足触发事件后，延迟多久才请求弹窗/浮窗等资源的具体信息, 单位为毫秒
     * validation: 
     */
    public int $delayRequestTime = 0;
    /**
     * @var  string
     * 触发事件操作符，参考CompositeOperatorEnum枚举值【and 所有触发事件要满足即可】【or 其中一个触发事件满足即可】
     * validation: 
     */
    public string $eventCompositeOperator;
    /**
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Config\TriggerEventDTO[]
     * 触发事件
     * validation: 
     */
    public array $events;

    public function __construct (int $pointId = 0, string $type = '', string $eventCompositeOperator = '', array $events = []) {
        $this->pointId = $pointId;
        $this->type = $type;
        $this->eventCompositeOperator = $eventCompositeOperator;
        $this->events = $events;
    }

    public static function create(int $pointId = 0, string $type = '', string $eventCompositeOperator = '', array $events = []): self {
        return new self($pointId, $type, $eventCompositeOperator, $events);
    }

    public function setPointId(int $pointId): self {
        $this->pointId = $pointId;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setDelayRequestTime(int $delayRequestTime): self {
        $this->delayRequestTime = $delayRequestTime;

        return $this;
    }

    public function setEventCompositeOperator(string $eventCompositeOperator): self {
        $this->eventCompositeOperator = $eventCompositeOperator;

        return $this;
    }

    public function setEvents(array $events): self {
        $this->events = $events;

        return $this;
    }
}