<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCategoryProductsByStoreIdByParams(array $params)
 * @method getCategoryProductsByCityIdByParams(array $params)
 */
class HimoProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某个门店下某个类目所有的产品.预约端
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByStoreId([
                            "storeId" => $storeId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * 获取某个城市下某个类目所有的产品.预约端
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $cityId 城市ID [ require true ]
     * @param  string $storeType 门店类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO
     */
    public static function getCategoryProductsByCityId (int $cityId, int $categoryId, string $storeType) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCategoryProductsByCityId([
                            "cityId" => $cityId,
                            "categoryId" => $categoryId,
                            "storeType" => $storeType,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Product\HimoProductCategoryBaseWithChildrenDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Product\HimoProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Product\HimoProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}