<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getShopCartInfoByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\HimoShopCartInfoCMD $params)
 */
class HimoShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得购物车信息.himo
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\HimoShopCartInfoCMD $shopCartInfo
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\HimoShopCartDTO
     */
    public static function getShopCartInfo (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\HimoShopCartInfoCMD $shopCartInfo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShopCartInfo($shopCartInfo),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\HimoShopCartDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'ShopCart\HimoShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'ShopCart\HimoShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}