<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Resource;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getResourcesByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Resource\ResourceCMD $params)
 * @method getResourcesV1ByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Resource\ResourceCMD $params)
 */
class Resource {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取资源列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Resource\ResourceCMD $resourceCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Resource\ResourceDTO[]
     */
    public static function getResources (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Resource\ResourceCMD $resourceCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResources($resourceCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Resource\ResourceDTO[]"
        );
    }


    /**
     * 获取资源列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Resource\ResourceCMD $resourceCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Resource\ResourceDTO[]
     */
    public static function getResourcesV1 (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Resource\ResourceCMD $resourceCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResourcesV1($resourceCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Resource\ResourceDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Resource\Resource');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Resource\Resource');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}