<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveShopCartByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\FamilyShopCartSaveCMD $params)
 * @method deleteShopCartByParams(array $params)
 * @method getShopCartInfoByParams(array $params)
 */
class FamilyShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 加入购物车.family
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\FamilyShopCartSaveCMD $familyShopCartSaveCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveShopCart (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\ShopCart\FamilyShopCartSaveCMD $familyShopCartSaveCmd) {
        return self::getClass()->saveShopCart($familyShopCartSaveCmd);
    }


    /**
     * 移出购物车.family
     *
     * @param  array $shopCartIds 购物车ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShopCart (array $shopCartIds) {
        return self::getClass()->deleteShopCart([
            "shopCartIds" => $shopCartIds,
        ]);
    }

    /**
     * 获得购物车信息.family
     *
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\ShopCartInfoDTO[]
     */
    public static function getShopCartInfo (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShopCartInfo([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ShopCart\ShopCartInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'ShopCart\FamilyShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'ShopCart\FamilyShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}